unit MainFrm;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, ComCtrls, Structure_IFO; // dichlarations for VMG and VTS structure

  // Imported from IFO manipulation Library:

  function  IdentifyType (Ifo: TMemoryStream): IfoFileType;        stdcall; external 'IfoLib.dll';

  procedure LoadIfoVMG   (Ifo: TMemoryStream; var IfoRecord: VMG); stdcall; external 'IfoLib.dll';
  procedure LoadIfoVTS   (Ifo: TMemoryStream; var IfoRecord: VTS); stdcall; external 'IfoLib.dll';

  procedure MakeIfoVMG   (var Ifo: TMemoryStream; IfoRecord: VMG); stdcall; external 'IfoLib.dll';
  procedure MakeIfoVTS   (var Ifo: TMemoryStream; IfoRecord: VTS); stdcall; external 'IfoLib.dll';

type
  TMainForm = class(TForm)
    B_Apri: TButton;
    B_Save: TButton;
    Label1: TLabel;
    Label2: TLabel;
    L_Identifier: TLabel;
    Label5: TLabel;
    L_FileName: TLabel;
    OpenDialog1: TOpenDialog;
    L_Provider: TLabel;
    L_Originale: TLabel;
    L_Ricalcolato: TLabel;
    L_Get: TLabel;
    B_Get: TButton;
    L_Type: TLabel;
    procedure B_ApriClick(Sender: TObject);
    procedure B_SaveClick(Sender: TObject);
    procedure B_GetClick(Sender: TObject);

  private
    function GetFileSize (const FileName: String): Integer;

  public

  end;

var
  MainForm: TMainForm;

implementation

{$R *.dfm}

var
  File_Name:  string;
  Ifo:        TMemoryStream;
  IfoSize:    LongWord;
  IfoRecdVTS: VTS;
  IfoRecdVMG: VMG;
  TypeOfFile: IfoFileType;


// ----------------------------------------------------------------------------
// Open .IFO file
// ----------------------------------------------------------------------------
procedure TMainForm.B_ApriClick(Sender: TObject);
begin
  B_Save.Enabled := false;

  if OpenDialog1.Execute then
  begin
    File_Name := OpenDialog1.FileName;
    L_FileName.Caption := File_Name;

    // Load file into MemoryStream
    Ifo := TMemoryStream.Create;
    Ifo.LoadFromFile(File_Name);

    // Identify data type
    TypeOfFile := IdentifyType(Ifo);

    if TypeOfFile = tIfoVTS then       // If VTS:
    begin
      // populate VTS structure
      LoadIfoVTS (Ifo, IfoRecdVTS);

      // update labels
      L_Type.Caption := 'VTS';
      L_Get.Caption := 'Calculate Last_Sector_of_VTS';
      L_Identifier.Caption  := 'Identifier: ' + IfoRecdVTS.VTSI_MAT.Identifier;
      L_Provider.Caption    := '';
      L_Originale.Caption   := 'Original: '  + IntToStr(IfoRecdVTS.VTSI_MAT.Last_sector_of_vts);
      L_Ricalcolato.Caption := 'Corrected:';
      IfoSize := IfoRecdVTS.VTSI_MAT.Last_sector_of_vtsi + 1;
    end
    else if TypeOfFile = tIfoVMG then  // If VMG:
    begin
      // populate VMG structure
      LoadIfoVMG (Ifo, IfoRecdVMG);

      // update labels
      L_Type.Caption := 'VMG';
      L_Get.Caption := 'Calculate Last_Sector_of_VMG';
      L_Identifier.Caption  := 'Identifier: ' + IfoRecdVMG.VMGI_MAT.Identifier;
      L_Provider.Caption    := 'Provider: '   + IfoRecdVMG.VMGI_MAT.Provider_ID;
      L_Originale.Caption   := 'Original: '  + IntToStr(IfoRecdVMG.VMGI_MAT.Last_sector_of_vmg);
      L_Ricalcolato.Caption := 'Corrected:';
      IfoSize := IfoRecdVMG.VMGI_MAT.Last_sector_of_vmgi + 1;
    end
    else                               // If other:
    begin
      // update labels
      L_Type.Caption := '?';
      L_Get.Caption := 'Calculate:';
      L_Identifier.Caption := 'Identifier: ';
      L_Provider.Caption := 'Provider: ';

      // error message
      ShowMessage('Not a IFO file !!');
    end;
    Ifo.Free;
  end;
end;


// ----------------------------------------------------------------------------
// GET VTS SECTORS: calculate real length
// ----------------------------------------------------------------------------
procedure TMainForm.B_GetClick(Sender: TObject);
var
  TotalSize: LongWord;
  sTemp: string;
  n: Integer;
begin
  TotalSize := IfoSize * 2;  // IFO + BUP
  case TypeOfFile of
    tIfoVMG:          // If VMG
      begin
        sTemp :=  ExtractFilePath(File_Name) + 'video_ts.vob';
        if FileExists(sTemp) then
          TotalSize := TotalSize + (GetFileSize(sTemp) div 2048);
        // update VMG structure with new value
        IfoRecdVMG.VMGI_MAT.Last_sector_of_vmg := TotalSize -1;
      end;
    tIfoVTS:          // If VTS
      begin
        for n := 0 to 9 do
        begin
          sTemp := Copy(File_Name,1,Length(File_Name)-5) + IntToStr(n) + '.vob';
          if FileExists(sTemp) then
            TotalSize := TotalSize + (GetFileSize(sTemp) div 2048);
        end;
        // update VTS structure with new value
        IfoRecdVTS.VTSI_MAT.Last_sector_of_vts := TotalSize -1;
      end;
  end;
  L_Ricalcolato.Caption := 'Corrected: ' + IntToStr(TotalSize - 1);

  B_Save.Enabled := true;
end;

// small routine that return file size
function TMainForm.GetFileSize (const FileName: String): Integer;
var
  F: file of Byte;
begin
  AssignFile(F, FileName);
  {$I-}Reset(F);{$I+}
  if IOResult = 0 then
  Begin
    Result := System.FileSize(F);
    CloseFile(F);
  end
  else
    Result := -1;
end;


// ----------------------------------------------------------------------------
// Save .IFO file
// ----------------------------------------------------------------------------
procedure TMainForm.B_SaveClick(Sender: TObject);
var
  Ifo: TMemoryStream;
begin
  Ifo := TMemoryStream.Create;

  // Create MemoryStream from structure
  case TypeOfFile of
    tIfoVMG: MakeIfoVMG (Ifo, IfoRecdVMG);
    tIfoVTS: MakeIfoVTS (Ifo, IfoRecdVTS);
  end;

  // Write MemoryStream to IFO and BUP files
  Ifo.SaveToFile(File_Name);
  Ifo.SaveToFile(ChangeFileExt(File_Name, '.bup'));

  Ifo.Free;
end;

end.
